function checkMandatory(x){
	
    if(x.value == ""){
        x.classList.add("is-invalid");
        x.classList.remove("is-valid");
        return false;
    }else{
        x.classList.remove("is-invalid");
        x.classList.add("is-valid");
        return true;
    }
}

function checkMandatorySelect(x){
	
    if(x.options[x.selectedIndex].value == ""){
        x.classList.add("is-invalid");
        x.classList.remove("is-valid");
        return false;
    }else{
        x.classList.remove("is-invalid");
        x.classList.add("is-valid");
        return true;
    }
}


function checkMandatoryAmount(x){
	
    if(parseFloat(x.value) < 1){
        x.classList.add("is-invalid");
        x.classList.remove("is-valid");
        return false;
    }else{
        x.classList.remove("is-invalid");
        x.classList.add("is-valid");
        return true;
    }
}

function checkValue(x){
	
    if(parseInt(x.value) < 0){
        x.classList.add("is-invalid");
        x.classList.remove("is-valid");
        return false;
    }else{
        x.classList.remove("is-invalid");
        x.classList.add("is-valid");
    }

    if(parseInt(x.value) == 0){
        x.classList.remove("is-valid");
        x.classList.remove("is-invalid");
        return false;
    }

    if(x.value == ""){
        x.classList.remove("is-valid");
        x.classList.add("is-invalid");
        return false;
    }

    return true;
}

function showErrorMessage(m){
    var msg = '<div class="col-12 alert alert-danger alert-dismissible bg-danger text-white border-0 fade show" role="alert">'
    msg = msg + '            <button type="button" class="close ml-auto" data-dismiss="alert" aria-label="Close">';
    msg = msg + '                    <span aria-hidden="true">×</span>';
    msg = msg + '                </button>';
    msg = msg + '                <strong>'+m;
    msg = msg + '            </div>'
    return msg;
}

function showSuccessMessage(m){
    var msg = '<div class="col-12 alert alert-success alert-dismissible bg-success text-white border-0 fade show" role="alert">'
    msg = msg + '            <button type="button" class="close ml-auto" data-dismiss="alert" aria-label="Close">';
    msg = msg + '                    <span aria-hidden="true">×</span>';
    msg = msg + '                </button>';
    msg = msg + '                <strong>'+m;
    msg = msg + '            </div>'
    return msg;
}

function showSuccessInfo(m){
    var msg = '<div class="col-12 alert alert-success" role="alert">';
        msg = msg + m;
        msg = msg +'</div>';
    return msg;
}

function getSelectValue(x){
    return x.options[x.selectedIndex].value;
}

function getSelectText(x){
    return x.options[x.selectedIndex].text;
}

function showWarningToast(h,m){
    toastr.warning(m, h, {timeOut: 5000 });

}

function showSuccessToast(h,m){
    toastr.success(m, h, {timeOut: 5000 });

}

function converTextToArray(y){
	var p_ids = document.forms[0].elements[y];
	var x = "";
	//alert(p_ids.length);
	for (var i = 0, len = p_ids.length; i < len; i++) {
	  //alert(p_ids[i].value);
	  x = x+"&"+y+"="+p_ids[i].value;
	}
	return x;
}

function converCheckBoxToArray(y){
	var p_ids = document.forms[0].elements[y];
	var x = "";
	var z = "";
	//alert(p_ids.length);
	for (var i = 0, len = p_ids.length; i < len; i++) {
	  //alert(p_ids[i].value);
	  if (p_ids[i].checked){
		  z = "1";
	  }else{
		  z = "0";
	  }
	  x = x+"&"+y+"="+z;
	}
	return x;
}

function converSelectToArray(y){
	var p_ids = document.forms[0].elements[y];
	var x = "";
	var z = "";
	//alert(p_ids.length);
	for (var i = 0, len = p_ids.length; i < len; i++) {
	  //alert(p_ids[i].value);
	  z = p_ids[i].options[p_ids[i].selectedIndex].value;
	  x = x+"&"+y+"="+z;
	}
	return x;
}

function addOption(selectElement, text, value){
    var x = selectElement;
    var option = document.createElement("option");
    option.text = text;
    option.value = value;
    x.add(option);
}

function removeOptions(selectElement) {
    console.log(selectElement)
   var i, L = selectElement.options.length - 1;
   for(i = L; i >= 1; i--) {
      selectElement.remove(i);
   }
}

function loadCategoriesToSelect(srcElement,destElement){

    removeOptions(document.getElementById(destElement));
    var item = getSelectValue(document.getElementById(srcElement));
    var dept = department_cateories[item];

    dept.forEach(element => {
      console.log(element)
      addOption(document.getElementById(destElement), element.name, element.exp_code)
    });
}